<?php
/**
 * Theme customizer
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

//--------------------------------------------------------------
//-- Register Customizer Controls
//--------------------------------------------------------------

define('CUSTOMIZE_PRIORITY', 200);		// Start priority for the new controls

if (!function_exists('windsor_customizer_register_controls')) {
	add_action( 'customize_register', 'windsor_customizer_register_controls', 11 );
	function windsor_customizer_register_controls( $wp_customize ) {

		// Setup standard WP Controls
		// ---------------------------------

		// Remove unused sections
		$wp_customize->remove_section( 'colors');
		$wp_customize->remove_section( 'static_front_page');

		// Reorder standard WP sections
		$sec = $wp_customize->get_panel( 'nav_menus' );
		if (is_object($sec)) $sec->priority = 30;
		$sec = $wp_customize->get_panel( 'widgets' );
		if (is_object($sec)) $sec->priority = 40;
		$sec = $wp_customize->get_section( 'title_tagline' );
		if (is_object($sec)) $sec->priority = 50;
		$sec = $wp_customize->get_section( 'background_image' );
		if (is_object($sec)) $sec->priority = 60;
		$sec = $wp_customize->get_section( 'header_image' );
		if (is_object($sec)) $sec->priority = 80;

		// Modify standard WP controls
		$sec = $wp_customize->get_control( 'blogname' );
		if (is_object($sec)) $sec->description      = esc_html__('Use "[[" and "]]" to modify style and color of parts of the text, "||" to break current line', 'windsor');
		$sec = $wp_customize->get_setting( 'blogname' );
		if (is_object($sec)) $sec->transport = 'postMessage';

		$sec = $wp_customize->get_setting( 'blogdescription' );
		if (is_object($sec)) $sec->transport = 'postMessage';

		$sec = $wp_customize->get_section( 'background_image' );
		if (is_object($sec)) {
			$sec->title = esc_html__('Background', 'windsor');
			$sec->description = esc_html__('Used only if "Content - Body style" equal to "boxed"', 'windsor');
		}

		// Move standard option 'Background Color' to the section 'Background Image'
		$wp_customize->add_setting( 'background_color', array(
			'default'        => get_theme_support( 'custom-background', 'default-color' ),
			'theme_supports' => 'custom-background',
			'transport'		 => 'postMessage',
			'sanitize_callback'    => 'sanitize_hex_color_no_hash',
			'sanitize_js_callback' => 'maybe_hash_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'background_color', array(
			'label'   => esc_html__( 'Background color', 'windsor' ),
			'section' => 'background_image',
		) ) );


		// Add Theme specific controls
		// ---------------------------------

		$panels = array('');
		$p = 0;
		$sections = array('');
		$s = 0;
		$i = 0;

		// Reload theme options because temporary theme mods is not ready when options was loaded first time
		windsor_load_theme_options();
		$options = windsor_storage_get('options');

		foreach ($options as $id=>$opt) {

			$i++;

			if (!empty($opt['hidden'])) continue;

			if ($opt['type'] == 'panel') {

				$sec = $wp_customize->get_panel( $id );
				if ( is_object($sec) && !empty($sec->title) ) {
					$sec->title      = $opt['title'];
					$sec->description= $opt['desc'];
					if ( !empty($opt['priority']) )	$sec->priority = $opt['priority'];
				} else {
					$wp_customize->add_panel( esc_attr($id) , array(
						'title'      => $opt['title'],
						'description'=> $opt['desc'],
						'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i
					) );
				}
				array_push($panels, $id);
				$p++;

			} else if ($opt['type'] == 'panel_end') {

				array_pop($panels);
				$p--;

			} else if ($opt['type'] == 'section') {

				$sec = $wp_customize->get_section( $id );
				if ( is_object($sec) && !empty($sec->title) ) {
					$sec->title      = $opt['title'];
					$sec->description= $opt['desc'];
					if ( !empty($opt['priority']) )	$sec->priority = $opt['priority'];
				} else {
					$wp_customize->add_section( esc_attr($id) , array(
						'title'      => $opt['title'],
						'description'=> $opt['desc'],
						'panel'  => esc_attr($panels[$p]),
						'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i
					) );
				}
				array_push($sections, $id);
				$s++;

			} else if ($opt['type'] == 'section_end') {

				array_pop($sections);
				$s--;

			} else if ($opt['type'] == 'select') {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => 'select',
					'choices'  => $opt['options']
				) );

			} else if ($opt['type'] == 'radio') {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => 'radio',
					'choices'  => $opt['options']
				) );

			} else if ($opt['type'] == 'switch') {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( new Windsor_Customize_Switch_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'choices'  => $opt['options']
				) ) );

			} else if ($opt['type'] == 'checkbox') {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => 'checkbox'
				) );

			} else if ($opt['type'] == 'color') {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'sanitize_hex_color',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if ($opt['type'] == 'image') {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if (in_array($opt['type'], array('media', 'audio', 'video'))) {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_value',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if ($opt['type'] == 'info') {

				$wp_customize->add_setting( $id, array(
					'default'           => '',
					'sanitize_callback' => 'windsor_sanitize_value',
					'transport'         => 'postMessage'
				) );

				$wp_customize->add_control( new Windsor_Customize_Info_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else if ($opt['type'] == 'hidden') {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_html',
					'transport'         => 'postMessage'
				) );

				$wp_customize->add_control( new Windsor_Customize_Hidden_Control( $wp_customize, $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority' => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
				) ) );

			} else {

				$wp_customize->add_setting( $id, array(
					'default'           => windsor_get_theme_option($id),
					'sanitize_callback' => 'windsor_sanitize_html',
					'transport'         => !isset($opt['refresh']) || $opt['refresh'] ? 'refresh' : 'postMessage'
				) );

				$wp_customize->add_control( $id, array(
					'label'    => $opt['title'],
					'description' => $opt['desc'],
					'section'  => esc_attr($sections[$s]),
					'priority'	 => !empty($opt['priority']) ? $opt['priority'] : CUSTOMIZE_PRIORITY+$i,
					'type'     => $opt['type']
				) );
			}

		}
	}
}


// Create custom controls for customizer
if (!function_exists('windsor_customizer_custom_controls')) {
	add_action( 'customize_register', 'windsor_customizer_custom_controls' );
	function windsor_customizer_custom_controls( $wp_customize ) {

		class Windsor_Customize_Info_Control extends WP_Customize_Control {
			public $type = 'info';

			public function render_content() {
				?>
				<label>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
					<span class="customize-control-description desctiption"><?php echo esc_html( $this->description ); ?></span>
				</label>
				<?php
			}
		}

		class Windsor_Customize_Switch_Control extends WP_Customize_Control {
			public $type = 'switch';

			public function render_content() {
				?>
				<label>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
					<span class="customize-control-description desctiption"><?php echo esc_html( $this->description ); ?></span>
					<?php
					if (is_array($this->choices) && count($this->choices)>0) {
						foreach ($this->choices as $k=>$v) {
							?><label><input type="radio" name="_customize-radio-<?php echo esc_attr($this->id); ?>" <?php $this->link(); ?> value="<?php echo esc_attr($k); ?>">
							<?php echo esc_html($v); ?></label><?php
						}
					}
					?>
				</label>
				<?php
			}
		}

		class Windsor_Customize_Hidden_Control extends WP_Customize_Control {
			public $type = 'info';

			public function render_content() {
				?>
				<input type="hidden" name="_customize-hidden-<?php echo esc_attr($this->id); ?>" <?php $this->link(); ?> value="">
				<?php
			}
		}

	}
}


// Sanitize plain value
if (!function_exists('windsor_sanitize_value')) {
	function windsor_sanitize_value($value) {
		return empty($value) ? $value : trim(strip_tags($value));
	}
}


// Sanitize html value
if (!function_exists('windsor_sanitize_html')) {
	function windsor_sanitize_html($value) {
		return empty($value) ? $value : wp_kses_post($value);
	}
}


//--------------------------------------------------------------
// Save custom settings in CSS file
//--------------------------------------------------------------

// Save CSS with custom colors and fonts after save custom options
if (!function_exists('windsor_customizer_action_save_after')) {
	add_action('customize_save_after', 'windsor_customizer_action_save_after');
	function windsor_customizer_action_save_after($api=false) {
		$settings = $api->settings();
		// Store new schemes colors
		$schemes = windsor_unserialize($settings['scheme_storage']->value());
		if (is_array($schemes) && count($schemes) > 0)
			windsor_storage_set('schemes', $schemes);
		// Regenerate CSS with new colors
		windsor_customizer_save_css();
	}
}

// Save CSS with custom colors and fonts after switch theme
if (!function_exists('windsor_customizer_action_switch_theme')) {
	function windsor_customizer_action_switch_theme() {
		windsor_customizer_save_css();
	}
}

// Save CSS with custom colors and fonts into custom.css
if (!function_exists('windsor_customizer_save_css')) {
	add_action('trx_addons_action_save_options', 'windsor_customizer_save_css');
	function windsor_customizer_save_css() {
		$msg = 	'/* ' . esc_html__("ATTENTION! This file was generated automatically! Don't change it!!!", 'windsor')
			. "\n----------------------------------------------------------------------- */\n";

		// Save CSS with custom colors and fonts into custom.css
		$css = windsor_customizer_get_css();
		$file = windsor_get_file_dir('css/__colors.css');
		if (file_exists($file)) windsor_fpc($file, $msg . $css );


		// Merge stylesheets
		$list = apply_filters( 'windsor_filter_merge_styles', array() );
		$css = '';
		foreach ($list as $f) {
			$css .= windsor_fgc(windsor_get_file_dir($f));
		}
		if ( $css != '') {
			windsor_fpc( windsor_get_file_dir('css/__styles.css'), $msg . windsor_minify_css( $css ) );
		}

		// Merge scripts
		$list = apply_filters( 'windsor_filter_merge_scripts', array(
				'js/skip-link-focus.js',
				'js/superfish.js',
				'js/bideo.js',
				'js/_utils.js',
				'js/_init.js'
			)
		);
		$js = '';
		foreach ($list as $f) {
			$js .= windsor_fgc(windsor_get_file_dir($f));
		}
		if ( $js != '') {
			windsor_fpc( windsor_get_file_dir('js/__scripts.js'), $msg . windsor_minify_js( $js ) );
		}
	}
}


//--------------------------------------------------------------
// Color schemes manipulations
//--------------------------------------------------------------

// Load saved values into color schemes
if (!function_exists('windsor_load_schemes')) {
	add_action('windsor_action_load_options', 'windsor_load_schemes');
	function windsor_load_schemes() {
		$schemes = windsor_storage_get('schemes');
		$storage = windsor_unserialize(windsor_get_theme_option('scheme_storage'));
		if (is_array($storage) && count($storage) > 0)  {
			foreach ($storage as $k=>$v) {
				if (isset($schemes[$k])) {
					$schemes[$k] = $v;
				}
			}
			windsor_storage_set('schemes', $schemes);
		}
	}
}

// Return specified color from current (or specified) color scheme
if ( !function_exists( 'windsor_get_scheme_color' ) ) {
	function windsor_get_scheme_color($color_name, $scheme = '') {
		if (empty($scheme)) $scheme = windsor_get_theme_option( 'color_scheme' );
		if (empty($scheme) || windsor_storage_empty('schemes', $scheme)) $scheme = 'default';
		$colors = windsor_storage_get_array('schemes', $scheme, 'colors');
		return $colors[$color_name];
	}
}

// Return colors from current color scheme
if ( !function_exists( 'windsor_get_scheme_colors' ) ) {
	function windsor_get_scheme_colors($scheme = '') {
		if (empty($scheme)) $scheme = windsor_get_theme_option( 'color_scheme' );
		if (empty($scheme) || windsor_storage_empty('schemes', $scheme)) $scheme = 'default';
		return windsor_storage_get_array('schemes', $scheme, 'colors');
	}
}

// Return list schemes
if ( !function_exists( 'windsor_get_theme_schemes' ) ) {
	function windsor_get_theme_schemes() {
		$list = array();
		$schemes = windsor_storage_get('schemes');
		if (is_array($schemes) && count($schemes) > 0) {
			foreach ($schemes as $slug => $scheme) {
				$list[$slug] = $scheme['title'];
			}
		}
		return $list;
	}
}

// Return theme fonts settings
if ( !function_exists( 'windsor_get_theme_fonts' ) ) {
	function windsor_get_theme_fonts($tag = '') {
		return !empty($tag) && !windsor_storage_empty('theme_fonts', $tag)
			? windsor_storage_get_array('theme_fonts', $tag)
			: windsor_storage_get('theme_fonts');
	}
}


//--------------------------------------------------------------
// Customizer JS and CSS
//--------------------------------------------------------------

// Binds JS listener to make Customizer color_scheme control.
// Passes color scheme data as colorScheme global.
if ( !function_exists( 'windsor_customizer_control_js' ) ) {
	add_action( 'customize_controls_enqueue_scripts', 'windsor_customizer_control_js' );
	function windsor_customizer_control_js() {
        wp_enqueue_style( 'windsor-customizer', windsor_get_file_url('theme-options/theme.customizer.css') );
        wp_enqueue_script( 'windsor-customizer-color-scheme-control', windsor_get_file_url('theme-options/theme.customizer.color-scheme.js'), array( 'customize-controls', 'iris', 'underscore', 'wp-util' ), null, true );
		wp_localize_script( 'windsor-customizer-color-scheme-control', 'windsor_color_schemes', windsor_storage_get('schemes') );
		wp_localize_script( 'windsor-customizer-color-scheme-control', 'windsor_dependencies', windsor_get_theme_dependencies() );
	}
}

// Binds JS handlers to make the Customizer preview reload changes asynchronously.
if ( !function_exists( 'windsor_customizer_preview_js' ) ) {
	add_action( 'customize_preview_init', 'windsor_customizer_preview_js' );
	function windsor_customizer_preview_js() {
        wp_enqueue_script( 'windsor-customize-preview', windsor_get_file_url('theme-options/theme.customizer.preview.js'), array( 'customize-preview' ), null, true );
	}
}

// Output an Underscore template for generating CSS for the color scheme.
// The template generates the css dynamically for instant display in the Customizer preview.
if ( !function_exists( 'windsor_customizer_css_template' ) ) {
	add_action( 'customize_controls_print_footer_scripts', 'windsor_customizer_css_template' );
	function windsor_customizer_css_template() {
		$colors = array(

			// Whole block border and background
			'bg_color'				=> '{{ data.bg_color }}',
			'bd_color'				=> '{{ data.bd_color }}',

			// Text and links colors
			'text'					=> '{{ data.text }}',
			'text_light'			=> '{{ data.text_light }}',
			'text_dark'				=> '{{ data.text_dark }}',
			'text_link'				=> '{{ data.text_link }}',
			'text_hover'			=> '{{ data.text_hover }}',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '{{ data.alter_bg_color }}',
			'alter_bg_hover'		=> '{{ data.alter_bg_hover }}',
			'alter_bd_color'		=> '{{ data.alter_bd_color }}',
			'alter_bd_hover'		=> '{{ data.alter_bd_hover }}',
			'alter_text'			=> '{{ data.alter_text }}',
			'alter_light'			=> '{{ data.alter_light }}',
			'alter_dark'			=> '{{ data.alter_dark }}',
			'alter_link'			=> '{{ data.alter_link }}',
			'alter_hover'			=> '{{ data.alter_hover }}',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '{{ data.input_bg_color }}',
			'input_bg_hover'		=> '{{ data.input_bg_hover }}',
			'input_bd_color'		=> '{{ data.input_bd_color }}',
			'input_bd_hover'		=> '{{ data.input_bd_hover }}',
			'input_text'			=> '{{ data.input_text }}',
			'input_light'			=> '{{ data.input_light }}',
			'input_dark'			=> '{{ data.input_dark }}',

			// Inverse blocks (with background equal to the links color or one of accented colors)
			'inverse_text'			=> '{{ data.inverse_text }}',
			'inverse_light'			=> '{{ data.inverse_light }}',
			'inverse_dark'			=> '{{ data.inverse_dark }}',
			'inverse_link'			=> '{{ data.inverse_link }}',
			'inverse_hover'			=> '{{ data.inverse_hover }}',

		);

		$schemes = array_keys(windsor_get_list_schemes());
		if (count($schemes) > 0) {
			$tmpl_holder = 'script';
			foreach ($schemes as $scheme) {
				echo '<' . esc_attr($tmpl_holder) . ' type="text/html" id="tmpl-windsor-color-scheme-'.esc_attr($scheme).'">'
					. windsor_customizer_get_css( $colors, false, false, $scheme )
					. '</' . esc_attr($tmpl_holder) . '>';
			}
		}
	}
}


// Add scheme name in each selector in the CSS (priority 100 - after complete css)
if (!function_exists('windsor_customizer_add_scheme_in_css')) {
	add_action( 'windsor_filter_get_css', 'windsor_customizer_add_scheme_in_css', 100, 4 );
	function windsor_customizer_add_scheme_in_css($css, $colors, $fonts, $scheme) {
		if ($colors && !empty($css['colors'])) {
			$rez = '';
			$in_comment = $in_rule = false;
			$allow = true;
			$scheme_class = sprintf('.scheme_%s ', $scheme);
			$self_class = '.scheme_self';
			$self_class_len = strlen($self_class);
			$css_str = str_replace(array('{{', '}}'), array('[[',']]'), $css['colors']);
			for ($i=0; $i<strlen($css_str); $i++) {
				$ch = $css_str[$i];
				if ($in_comment) {
					$rez .= $ch;
					if ($ch=='/' && $css_str[$i-1]=='*') {
						$in_comment = false;
						$allow = !$in_rule;
					}
				} else if ($in_rule) {
					$rez .= $ch;
					if ($ch=='}') {
						$in_rule = false;
						$allow = !$in_comment;
					}
				} else {
					if ($ch=='/' && $css_str[$i+1]=='*') {
						$rez .= $ch;
						$in_comment = true;
					} else if ($ch=='{') {
						$rez .= $ch;
						$in_rule = true;
					} else if ($ch==',') {
						$rez .= $ch;
						$allow = true;
					} else if (strpos(" \t\r\n", $ch)===false) {
						if ($allow && substr($css_str, $i, $self_class_len) == $self_class) {
							$rez .= trim($scheme_class);
							$i += $self_class_len - 1;
						} else
							$rez .= ($allow ? $scheme_class : '') . $ch;
						$allow = false;
					} else {
						$rez .= $ch;
					}
				}
			}
			$rez = str_replace(array('[[',']]'), array('{{', '}}'), $rez);
			$css['colors'] = $rez;
		}
		return $css;
	}
}




// -----------------------------------------------------------------
// -- Page Options section
// -----------------------------------------------------------------

if ( !function_exists('windsor_init_override') ) {
	add_action( 'after_setup_theme', 'windsor_init_override' );
	function windsor_init_override() {
		if ( is_admin() ) {
			add_action("admin_enqueue_scripts", 'windsor_add_override_scripts');
			add_action('save_post',			'windsor_save_override');
			add_filter('windsor_filter_override_options', 'windsor_add_override');
		}
	}
}

// Load required styles and scripts for admin mode
if ( !function_exists( 'windsor_add_override_scripts' ) ) {
	add_action("admin_enqueue_scripts", 'windsor_add_override_scripts');
	function windsor_add_override_scripts() {
		// If current screen is 'Edit Page' - load fontello
		$screen = get_current_screen();
		if (windsor_allow_override($screen->id) && windsor_allow_override($screen->post_type)) {
            wp_enqueue_style( 'fontello-icons',  windsor_get_file_url('css/fontello/fontello-embedded.css') );
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui'), null, true);
            wp_enqueue_script( 'windsor-override-options', windsor_get_file_url('theme-options/theme.override.js'), array('jquery'), null, true );
			wp_localize_script( 'windsor-override-options', 'windsor_dependencies', windsor_get_theme_dependencies() );
		}
	}
}


// Check if override options is allow
if (!function_exists('windsor_allow_override')) {
	function windsor_allow_override($post_type) {
		return apply_filters('windsor_filter_allow_override', in_array($post_type, array('page', 'post')), $post_type);
	}
}

// Add override options
if (!function_exists('windsor_add_override')) {
	function windsor_add_override($list=array()) {
		global $post_type;
		if (windsor_allow_override($post_type)) {
			$list[] = array(sprintf('windsor_override_%s', $post_type),
				esc_html__('Theme Options', 'windsor'),
				'windsor_show_override',
				$post_type,
				'advanced',
				'default'
			);
		}
		return $list;
	}
}

// Callback function to show fields in override options
if (!function_exists('windsor_show_override')) {
	function windsor_show_override() {
		global $post, $post_type;
		if (windsor_allow_override($post_type)) {
			// Load saved options
			$meta = get_post_meta($post->ID, 'windsor_options', true);
			$tabs_titles = $tabs_content = array();
			$options = windsor_storage_get('options');
			foreach ($options as $k=>$v) {
				if (!isset($v['override']) || strpos($v['override']['mode'], $post_type)===false) continue;
				if (empty($v['override']['section']))
					$v['override']['section'] = esc_html__('General', 'windsor');
				if (!isset($tabs_titles[$v['override']['section']])) {
					$tabs_titles[$v['override']['section']] = $v['override']['section'];
					$tabs_content[$v['override']['section']] = '';
				}
				$v['val'] = isset($meta[$k]) ? $meta[$k] : 'inherit';
				$tabs_content[$v['override']['section']] .= windsor_show_override_field($k, $v);
			}
			if (count($tabs_titles) > 0) {
				?>
				<div class="windsor_override">
					<input type="hidden" name="override_post_nonce" value="<?php echo esc_attr(wp_create_nonce(admin_url())); ?>" />
					<input type="hidden" name="override_post_type" value="<?php echo esc_attr($post_type); ?>" />
					<div id="windsor_override_tabs">
						<ul><?php
							$cnt = 0;
							foreach ($tabs_titles as $k=>$v) {
								$cnt++;
								?><li><a href="#windsor_override_<?php echo esc_attr($cnt); ?>"><?php echo esc_html($v); ?></a></li><?php
							}
							?></ul>
						<?php
						$cnt = 0;
						foreach ($tabs_content as $k=>$v) {
							$cnt++;
							?>
							<div id="windsor_override_<?php echo esc_attr($cnt); ?>" class="windsor_override_section">
								<?php windsor_show_layout($v); ?>
							</div>
							<?php
						}
						?>
					</div>
				</div>
				<?php
			}
		}
	}
}

// Display single option's field
if ( !function_exists('windsor_show_override_field') ) {
	function windsor_show_override_field($name, $field) {
		$inherit_state = windsor_is_inherit($field['val']);
		$output = '<div class="windsor_override_item windsor_override_item_'.esc_attr($field['type']).' windsor_override_inherit_'.($inherit_state ? 'on' : 'off' ).'">'
			. '<h4 class="windsor_override_item_title">'
			. esc_html($field['title'])
			. '<span class="windsor_override_inherit_lock" id="windsor_override_inherit_'.esc_attr($name).'"></span>'
			. '</h4>'
			. '<div class="windsor_override_item_data">'
			. '<div class="windsor_override_item_field" data-param="'.esc_attr($name).'">';
		if ($field['type']=='checkbox') {
			$output .= '<label class="windsor_override_item_label">'
				. '<input type="checkbox" name="windsor_override_field_'.esc_attr($name).'" value="1"'.($field['val']==1 ? ' checked="checked"' : '').' />'
				. esc_html($field['title'])
				. '</label>';
		} else if ($field['type']=='switch' || $field['type']=='radio') {
			foreach ($field['options'] as $k=>$v) {
				$output .= '<label class="windsor_override_item_label">'
					. '<input type="radio" name="windsor_override_field_'.esc_attr($name).'" value="'.esc_attr($k).'"'.($field['val']==$k ? ' checked="checked"' : '').' />'
					. esc_html($v)
					. '</label>';
			}
		} else if ($field['type']=='text') {
			$output .= '<input type="text" name="windsor_override_field_'.esc_attr($name).'" value="'.esc_attr(windsor_is_inherit($field['val']) ? '' : $field['val']).'" />';
		} else if ($field['type']=='textarea') {
			$output .= '<textarea name="windsor_override_field_'.esc_attr($name).'">'.esc_html(windsor_is_inherit($field['val']) ? '' : $field['val']).'</textarea>';
		} else if ($field['type']=='select') {
			$output .= '<select size="1" name="windsor_override_field_'.esc_attr($name).'">';
			foreach ($field['options'] as $k=>$v) {
				$output .= '<option value="'.esc_attr($k).'"'.($field['val']==$k ? ' selected="selected"' : '').'>'.esc_html($v).'</option>';
			}
			$output .= '</select>';
		} else if (in_array($field['type'], array('image', 'media', 'video', 'audio'))) {
			$output .= '<input type="text" id="windsor_override_field_'.esc_attr($name).'" name="windsor_override_field_'.esc_attr($name).'" value="'.esc_attr(windsor_is_inherit($field['val']) ? '' : $field['val']).'" />'
				. windsor_show_custom_field('windsor_override_field_'.esc_attr($name).'_button', array(
					'type'				=> 'mediamanager',
					'data_type'			=> $field['type'],
					'linked_field_id'	=> 'windsor_override_field_'.esc_attr($name)),
					null)
				. '<div class="windsor_override_field_preview">'
				. (windsor_is_inherit($field['val']) ? '' : ($field['val'] && $field['type']=='image' ? '<img src="' . esc_url($field['val']) . '" alt="' . esc_attr__('Image', 'windsor') . '">' : basename($field['val'])))
				. '</div>';
		}
		$output .= '<div class="windsor_override_inherit_cover'.(!$inherit_state ? ' windsor_hidden' : '').'">'
			. '<span class="windsor_override_inherit_label">' . esc_html__('Inherit', 'windsor') . '</span>'
			. '<input type="hidden" name="windsor_override_inherit_'.esc_attr($name).'" value="'.esc_attr($inherit_state ? 'inherit' : '').'" />'
			. '</div>'
			. '</div>'
			. '<div class="windsor_override_item_description">'
			. (!empty($field['override']['desc']) ? $field['override']['desc'] : $field['desc'])
			. '</div>'
			. '</div>'
			. '</div>';
		return $output;
	}
}

// Save data from override options
if (!function_exists('windsor_save_override')) {
	
	function windsor_save_override($post_id) {

		// verify nonce
		if ( !wp_verify_nonce( windsor_get_value_gp('override_post_nonce'), admin_url() ) )
			return $post_id;

		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
			return $post_id;
		}

		$post_type = isset($_POST['override_post_type']) ? sanitize_text_field($_POST['override_post_type']) : sanitize_text_field($_POST['post_type']);

		// check permissions
		$capability = 'page';
		$post_types = get_post_types( array( 'name' => $post_type), 'objects' );
		if (!empty($post_types) && is_array($post_types)) {
			foreach ($post_types  as $type) {
				$capability = $type->capability_type;
				break;
			}
		}
		if (!current_user_can('edit_'.($capability), $post_id)) {
			return $post_id;
		}

		// Save meta
		$meta = array();
		$options = windsor_storage_get('options');
		foreach ($options as $k=>$v) {
			// Skip not overriden options
			if (!isset($v['override']) || strpos($v['override']['mode'], $post_type)===false) continue;
			// Skip inherited options
			if (!empty($_POST['windsor_override_inherit_' . $k])) continue;
			// Get option value from POST
			$meta[$k] = isset($_POST['windsor_override_field_' . $k])
				? windsor_get_value_gpc('windsor_override_field_' . $k)
				: ($v['type']=='checkbox' ? 0 : '');
		}
		update_post_meta($post_id, 'windsor_options', $meta);
	}
}


//--------------------------------------------------------------
//-- Load Options list and styles
//--------------------------------------------------------------
require_once trailingslashit( get_template_directory() ) . 'theme-options/theme.options.php';
require_once trailingslashit( get_template_directory() ) . 'theme-options/theme.styles.php';