<?php
/**
 * The template to show mobile menu
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

$mobile_color_scheme = 'dark';

if (strpos('brown', windsor_get_theme_option('color_scheme')) !== false) {
	$mobile_color_scheme = 'brown_dark';
}
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile scheme_<?php windsor_show_layout($mobile_color_scheme)?>">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close icon-cancel"></a><?php
		// Logo
		get_template_part( 'templates/header-logo' );

		// Main menu
		?>
		<nav class="menu_mobile_nav_area">
			<?php
			echo str_replace(
					array('id="menu_main', 'id="menu-', 'class="menu_main'),
					array('id="menu_mobile', 'id="menu_mobile-', 'class="menu_mobile'),
					get_query_var('windsor_menu_main')
					);
			?>
		</nav><?php
	
		// Search field
		?>
		<div class="search_mobile">
			<div class="search_form_wrap">
				<form role="search" method="get" class="search_form" action="<?php echo esc_url(home_url('/')); ?>">
					<input type="text" class="search_field" placeholder="<?php esc_attr_e('Search ...', 'windsor'); ?>" value="<?php echo esc_attr(get_search_query()); ?>" name="s">
					<button type="submit" class="search_submit icon-search" title="<?php esc_attr_e('Start search', 'windsor'); ?>"></button>
				</form>
			</div>
		</div>
		<?php
		
		// Social icons
		windsor_show_layout(windsor_get_socials_links(), '<div class="socials_mobile">', '</div>');
		?>
	</div>
</div>
