<?php
/**
 * Theme lists
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }



// Return numbers range
if ( !function_exists( 'windsor_get_list_range' ) ) {
	function windsor_get_list_range($from=1, $to=2, $prepend_inherit=false) {
		$list = array();
		for ($i=$from; $i<=$to; $i++)
			$list[$i] = $i;
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}



// Return styles list
if ( !function_exists( 'windsor_get_list_styles' ) ) {
	function windsor_get_list_styles($from=1, $to=2, $prepend_inherit=false) {
		$list = array();
		for ($i=$from; $i<=$to; $i++)
			$list[$i] = sprintf(esc_html__('Style %d', 'windsor'), $i);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}



// Return schemes list
if ( !function_exists( 'windsor_get_list_schemes' ) ) {
	function windsor_get_list_schemes($prepend_inherit=false) {
		if (($list = windsor_storage_get('list_schemes'))=='') {
			$list = windsor_get_theme_schemes();
			windsor_storage_set('list_schemes', $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the headers
if ( !function_exists( 'windsor_get_list_header_styles' ) ) {
	function windsor_get_list_header_styles($prepend_inherit=false) {
		$list = array(
			'header-1'	=> esc_html__('Header 1',	'windsor'),
			'header-2'	=> esc_html__('Header 2',	'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the header's positions
if ( !function_exists( 'windsor_get_list_header_positions' ) ) {
	function windsor_get_list_header_positions($prepend_inherit=false) {
		$list = array(
			'default'	=> esc_html__('Default','windsor'),
			'over'		=> esc_html__('Over',	'windsor'),
			'under'		=> esc_html__('Under',	'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the main menu positions
if ( !function_exists( 'windsor_get_list_menu_positions' ) ) {
	function windsor_get_list_menu_positions($prepend_inherit=false) {
		$list = array(
			'top'	=> esc_html__('Top',	'windsor'),
			'left'	=> esc_html__('Left',	'windsor'),
			'right'	=> esc_html__('Right',	'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the animations
if ( !function_exists( 'windsor_get_list_animations' ) ) {
	function windsor_get_list_animations($prepend_inherit=false) {
		$list = array(
			'none'			=> esc_html__('- None -',	'windsor'),
			'bounced'		=> esc_html__('Bounced',	'windsor'),
			'elastic'		=> esc_html__('Elastic',	'windsor'),
			'flash'			=> esc_html__('Flash',		'windsor'),
			'flip'			=> esc_html__('Flip',		'windsor'),
			'pulse'			=> esc_html__('Pulse',		'windsor'),
			'rubberBand'	=> esc_html__('Rubber Band','windsor'),
			'shake'			=> esc_html__('Shake',		'windsor'),
			'swing'			=> esc_html__('Swing',		'windsor'),
			'tada'			=> esc_html__('Tada',		'windsor'),
			'wobble'		=> esc_html__('Wobble',		'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the enter animations
if ( !function_exists( 'windsor_get_list_animations_in' ) ) {
	function windsor_get_list_animations_in($prepend_inherit=false) {
		$list = array(
			'none'				=> esc_html__('- None -',			'windsor'),
			'bounceIn'			=> esc_html__('Bounce In',			'windsor'),
			'bounceInUp'		=> esc_html__('Bounce In Up',		'windsor'),
			'bounceInDown'		=> esc_html__('Bounce In Down',		'windsor'),
			'bounceInLeft'		=> esc_html__('Bounce In Left',		'windsor'),
			'bounceInRight'		=> esc_html__('Bounce In Right',	'windsor'),
			'elastic'			=> esc_html__('Elastic In',			'windsor'),
			'fadeIn'			=> esc_html__('Fade In',			'windsor'),
			'fadeInUp'			=> esc_html__('Fade In Up',			'windsor'),
			'fadeInUpSmall'		=> esc_html__('Fade In Up Small',	'windsor'),
			'fadeInUpBig'		=> esc_html__('Fade In Up Big',		'windsor'),
			'fadeInDown'		=> esc_html__('Fade In Down',		'windsor'),
			'fadeInDownBig'		=> esc_html__('Fade In Down Big',	'windsor'),
			'fadeInLeft'		=> esc_html__('Fade In Left',		'windsor'),
			'fadeInLeftBig'		=> esc_html__('Fade In Left Big',	'windsor'),
			'fadeInRight'		=> esc_html__('Fade In Right',		'windsor'),
			'fadeInRightBig'	=> esc_html__('Fade In Right Big',	'windsor'),
			'flipInX'			=> esc_html__('Flip In X',			'windsor'),
			'flipInY'			=> esc_html__('Flip In Y',			'windsor'),
			'lightSpeedIn'		=> esc_html__('Light Speed In',		'windsor'),
			'rotateIn'			=> esc_html__('Rotate In',			'windsor'),
			'rotateInUpLeft'	=> esc_html__('Rotate In Down Left','windsor'),
			'rotateInUpRight'	=> esc_html__('Rotate In Up Right',	'windsor'),
			'rotateInDownLeft'	=> esc_html__('Rotate In Up Left',	'windsor'),
			'rotateInDownRight'	=> esc_html__('Rotate In Down Right','windsor'),
			'rollIn'			=> esc_html__('Roll In',			'windsor'),
			'slideInUp'			=> esc_html__('Slide In Up',		'windsor'),
			'slideInDown'		=> esc_html__('Slide In Down',		'windsor'),
			'slideInLeft'		=> esc_html__('Slide In Left',		'windsor'),
			'slideInRight'		=> esc_html__('Slide In Right',		'windsor'),
			'wipeInLeftTop'		=> esc_html__('Wipe In Left Top',	'windsor'),
			'zoomIn'			=> esc_html__('Zoom In',			'windsor'),
			'zoomInUp'			=> esc_html__('Zoom In Up',			'windsor'),
			'zoomInDown'		=> esc_html__('Zoom In Down',		'windsor'),
			'zoomInLeft'		=> esc_html__('Zoom In Left',		'windsor'),
			'zoomInRight'		=> esc_html__('Zoom In Right',		'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the out animations
if ( !function_exists( 'windsor_get_list_animations_out' ) ) {
	function windsor_get_list_animations_out($prepend_inherit=false) {
		$list = array(
			'none'			=> esc_html__('- None -',			'windsor'),
			'bounceOut'		=> esc_html__('Bounce Out',			'windsor'),
			'bounceOutUp'	=> esc_html__('Bounce Out Up',		'windsor'),
			'bounceOutDown'	=> esc_html__('Bounce Out Down',	'windsor'),
			'bounceOutLeft'	=> esc_html__('Bounce Out Left',	'windsor'),
			'bounceOutRight'=> esc_html__('Bounce Out Right',	'windsor'),
			'fadeOut'		=> esc_html__('Fade Out',			'windsor'),
			'fadeOutUp'		=> esc_html__('Fade Out Up',		'windsor'),
			'fadeOutUpBig'	=> esc_html__('Fade Out Up Big',	'windsor'),
			'fadeOutDownSmall'	=> esc_html__('Fade Out Down Small','windsor'),
			'fadeOutDownBig'=> esc_html__('Fade Out Down Big',	'windsor'),
			'fadeOutDown'	=> esc_html__('Fade Out Down',		'windsor'),
			'fadeOutLeft'	=> esc_html__('Fade Out Left',		'windsor'),
			'fadeOutLeftBig'=> esc_html__('Fade Out Left Big',	'windsor'),
			'fadeOutRight'	=> esc_html__('Fade Out Right',		'windsor'),
			'fadeOutRightBig'=> esc_html__('Fade Out Right Big','windsor'),
			'flipOutX'		=> esc_html__('Flip Out X',			'windsor'),
			'flipOutY'		=> esc_html__('Flip Out Y',			'windsor'),
			'hinge'			=> esc_html__('Hinge Out',			'windsor'),
			'lightSpeedOut'	=> esc_html__('Light Speed Out',	'windsor'),
			'rotateOut'		=> esc_html__('Rotate Out',			'windsor'),
			'rotateOutUpLeft'	=> esc_html__('Rotate Out Down Left',	'windsor'),
			'rotateOutUpRight'	=> esc_html__('Rotate Out Up Right',	'windsor'),
			'rotateOutDownLeft'	=> esc_html__('Rotate Out Up Left',		'windsor'),
			'rotateOutDownRight'=> esc_html__('Rotate Out Down Right',	'windsor'),
			'rollOut'			=> esc_html__('Roll Out',		'windsor'),
			'slideOutUp'		=> esc_html__('Slide Out Up',	'windsor'),
			'slideOutDown'		=> esc_html__('Slide Out Down',	'windsor'),
			'slideOutLeft'		=> esc_html__('Slide Out Left',	'windsor'),
			'slideOutRight'		=> esc_html__('Slide Out Right','windsor'),
			'zoomOut'			=> esc_html__('Zoom Out',		'windsor'),
			'zoomOutUp'			=> esc_html__('Zoom Out Up',	'windsor'),
			'zoomOutDown'		=> esc_html__('Zoom Out Down',	'windsor'),
			'zoomOutLeft'		=> esc_html__('Zoom Out Left',	'windsor'),
			'zoomOutRight'		=> esc_html__('Zoom Out Right',	'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return classes list for the specified animation
if (!function_exists('windsor_get_animation_classes')) {
	function windsor_get_animation_classes($animation, $speed='normal', $loop='none') {
		return windsor_is_off($animation) ? '' : 'animated '.esc_attr($animation).' '.esc_attr($speed).(!windsor_is_off($loop) ? ' '.esc_attr($loop) : '');
	}
}


// Return list of categories
if ( !function_exists( 'windsor_get_list_categories' ) ) {
	function windsor_get_list_categories($prepend_inherit=false) {
		if (($list = windsor_storage_get('list_categories'))=='') {
			$list = array();
			$args = array(
				'type'                     => 'post',
				'child_of'                 => 0,
				'parent'                   => '',
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 0,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => 'category',
				'pad_counts'               => false );
			$taxonomies = get_categories( $args );
			if (is_array($taxonomies) && count($taxonomies) > 0) {
				foreach ($taxonomies as $cat) {
					$list[$cat->term_id] = $cat->name;
				}
			}
			windsor_storage_set('list_categories', $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of taxonomies
if ( !function_exists( 'windsor_get_list_terms' ) ) {
	function windsor_get_list_terms($prepend_inherit=false, $taxonomy='category') {
		if (($list = windsor_storage_get('list_taxonomies_'.($taxonomy)))=='') {
			$list = array();
			$args = array(
				'child_of'                 => 0,
				'parent'                   => '',
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 0,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => $taxonomy,
				'pad_counts'               => false );
			$taxonomies = get_terms( $taxonomy, $args );
			if (is_array($taxonomies) && count($taxonomies) > 0) {
				foreach ($taxonomies as $cat) {
					$list[$cat->term_id] = $cat->name;
				}
			}
			windsor_storage_set('list_taxonomies_'.($taxonomy), $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list of post's types
if ( !function_exists( 'windsor_get_list_posts_types' ) ) {
	function windsor_get_list_posts_types($prepend_inherit=false) {
		if (($list = windsor_storage_get('list_posts_types'))=='') {
			$list = get_post_types();
			windsor_storage_set('list_posts_types', $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list post items from any post type and taxonomy
if ( !function_exists( 'windsor_get_list_posts' ) ) {
	function windsor_get_list_posts($prepend_inherit=false, $opt=array()) {
		$opt = array_merge(array(
			'post_type'			=> 'post',
			'post_status'		=> 'publish',
			'taxonomy'			=> 'category',
			'taxonomy_value'	=> '',
			'posts_per_page'	=> -1,
			'orderby'			=> 'post_date',
			'order'				=> 'desc',
			'return'			=> 'id'
			), is_array($opt) ? $opt : array('post_type'=>$opt));

		$hash = 'list_posts_'.($opt['post_type']).'_'.($opt['taxonomy']).'_'.($opt['taxonomy_value']).'_'.($opt['orderby']).'_'.($opt['order']).'_'.($opt['return']).'_'.($opt['posts_per_page']);
		if (($list = windsor_storage_get($hash))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'windsor');
			$args = array(
				'post_type' => $opt['post_type'],
				'post_status' => $opt['post_status'],
				'posts_per_page' => $opt['posts_per_page'],
				'ignore_sticky_posts' => true,
				'orderby'	=> $opt['orderby'],
				'order'		=> $opt['order']
			);
			if (!empty($opt['taxonomy_value'])) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => $opt['taxonomy'],
						'field' => (int) $opt['taxonomy_value'] > 0 ? 'id' : 'slug',
						'terms' => $opt['taxonomy_value']
					)
				);
			}
			$posts = get_posts( $args );
			if (is_array($posts) && count($posts) > 0) {
				foreach ($posts as $post) {
					$list[$opt['return']=='id' ? $post->ID : $post->post_title] = $post->post_title;
				}
			}
			windsor_storage_set($hash, $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of registered users
if ( !function_exists( 'windsor_get_list_users' ) ) {
	function windsor_get_list_users($prepend_inherit=false, $roles=array('administrator', 'editor', 'author', 'contributor', 'shop_manager')) {
		if (($list = windsor_storage_get('list_users'))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'windsor');
			$args = array(
				'orderby'	=> 'display_name',
				'order'		=> 'ASC' );
			$users = get_users( $args );
			if (is_array($users) && count($users) > 0) {
				foreach ($users as $user) {
					$accept = true;
					if (is_array($user->roles)) {
						if (is_array($user->roles) && count($user->roles) > 0) {
							$accept = false;
							foreach ($user->roles as $role) {
								if (in_array($role, $roles)) {
									$accept = true;
									break;
								}
							}
						}
					}
					if ($accept) $list[$user->user_login] = $user->display_name;
				}
			}
			windsor_storage_set('list_users', $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return menus list, prepended inherit
if ( !function_exists( 'windsor_get_list_menus' ) ) {
	function windsor_get_list_menus($prepend_inherit=false) {
		if (($list = windsor_storage_get('list_menus'))=='') {
			$list = array();
			$list['default'] = esc_html__("Default", 'windsor');
			$menus = wp_get_nav_menus();
			if (is_array($menus) && count($menus) > 0) {
				foreach ($menus as $menu) {
					$list[$menu->slug] = $menu->name;
				}
			}
			windsor_storage_set('list_menus', $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return custom sidebars list, prepended inherit and main sidebars item (if need)
if ( !function_exists( 'windsor_get_list_sidebars' ) ) {
	function windsor_get_list_sidebars($prepend_inherit=false) {
		if (($list = windsor_storage_get('list_sidebars'))=='') {
			$list = apply_filters('windsor_filter_list_sidebars', array(
				'sidebar_widgets'		=> esc_html__('Sidebar Widgets', 'windsor'),
				'header_widgets'		=> esc_html__('Header Widgets', 'windsor'),
				'above_page_widgets'	=> esc_html__('Above Page Widgets', 'windsor'),
				'above_content_widgets' => esc_html__('Above Content Widgets', 'windsor'),
				'below_content_widgets' => esc_html__('Below Content Widgets', 'windsor'),
				'below_page_widgets' 	=> esc_html__('Below Page Widgets', 'windsor'),
				'footer_widgets'		=> esc_html__('Footer Widgets', 'windsor')
				)
			);
			$custom_sidebars_number = max(0, min(10, windsor_get_theme_setting('custom_sidebars')));
            if ( is_array($custom_sidebars_number) && count($custom_sidebars_number) > 0) {
				for ($i=1; $i <= $custom_sidebars_number; $i++) {
					$list['custom_widgets_'.intval($i)] = sprintf(esc_html__('Custom Widgets %d', 'windsor'), $i);
				}
			}
			windsor_storage_set('list_sidebars', $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return sidebars positions
if ( !function_exists( 'windsor_get_list_sidebars_positions' ) ) {
	function windsor_get_list_sidebars_positions($prepend_inherit=false) {
		$list = array(
			'left'  => esc_html__('Left',  'windsor'),
			'right' => esc_html__('Right', 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return body styles list, prepended inherit
if ( !function_exists( 'windsor_get_list_body_styles' ) ) {
	function windsor_get_list_body_styles($prepend_inherit=false) {
		$list = array(
			'boxed'		=> esc_html__('Boxed',		'windsor'),
			'wide'		=> esc_html__('Wide',		'windsor'),
			'fullwide'	=> esc_html__('Fullwide',	'windsor'),
			'fullscreen'=> esc_html__('Fullscreen',	'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return blog styles list, prepended inherit
if ( !function_exists( 'windsor_get_list_blog_styles' ) ) {
	function windsor_get_list_blog_styles($prepend_inherit=false) {
		$list = array(
			'excerpt'	=> esc_html__('Excerpt','windsor'),
			'classic_2'	=> esc_html__('Classic /2 columns/',	'windsor'),
			'classic_3'	=> esc_html__('Classic /3 columns/',	'windsor'),
			'portfolio_2' => esc_html__('Portfolio /2 columns/','windsor'),
			'portfolio_3' => esc_html__('Portfolio /3 columns/','windsor'),
			'portfolio_4' => esc_html__('Portfolio /4 columns/','windsor'),
			'gallery_2' => esc_html__('Gallery /2 columns/',	'windsor'),
			'gallery_3' => esc_html__('Gallery /3 columns/',	'windsor'),
			'gallery_4' => esc_html__('Gallery /4 columns/',	'windsor'),
			'chess_1'	=> esc_html__('Chess /2 column/',		'windsor'),
			'chess_2'	=> esc_html__('Chess /4 columns/',		'windsor'),
			'chess_3'	=> esc_html__('Chess /6 columns/',		'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return blog contents list, prepended inherit
if ( !function_exists( 'windsor_get_list_blog_content' ) ) {
	function windsor_get_list_blog_content($prepend_inherit=false) {
		$list = array(
			'excerpt'	=> esc_html__('Excerpt',	'windsor'),
			'fullpost'	=> esc_html__('Full post',	'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with pagination styles
if ( !function_exists( 'windsor_get_list_paginations' ) ) {
	function windsor_get_list_paginations($prepend_inherit=false) {
		$list = array(
			'pages'	=> esc_html__("Page numbers", 'windsor'),
			'links'	=> esc_html__("Older/Newest", 'windsor'),
			'more'	=> esc_html__("Load more", 'windsor'),
			'infinite' => esc_html__("Infinite scroll", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the bg image positions
if ( !function_exists( 'windsor_get_list_bg_image_positions' ) ) {
	function windsor_get_list_bg_image_positions($prepend_inherit=false) {
		$list = array(
			'left top'		=> esc_html__('Left Top', 'windsor'),
			'center top'	=> esc_html__("Center Top", 'windsor'),
			'right top'		=> esc_html__("Right Top", 'windsor'),
			'left center'	=> esc_html__("Left Center", 'windsor'),
			'center center'	=> esc_html__("Center Center", 'windsor'),
			'right center'	=> esc_html__("Right Center", 'windsor'),
			'left bottom'	=> esc_html__("Left Bottom", 'windsor'),
			'center bottom'	=> esc_html__("Center Bottom", 'windsor'),
			'right bottom'	=> esc_html__("Right Bottom", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the bg image repeat
if ( !function_exists( 'windsor_get_list_bg_image_repeats' ) ) {
	function windsor_get_list_bg_image_repeats($prepend_inherit=false) {
		$list = array(
			'repeat'	=> esc_html__('Repeat', 'windsor'),
			'repeat-x'	=> esc_html__('Repeat X', 'windsor'),
			'repeat-y'	=> esc_html__('Repeat Y', 'windsor'),
			'no-repeat'	=> esc_html__('No Repeat', 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}


// Return list of the bg image attachment
if ( !function_exists( 'windsor_get_list_bg_image_attachments' ) ) {
	function windsor_get_list_bg_image_attachments($prepend_inherit=false) {
		$list = array(
			'scroll'	=> esc_html__('Scroll', 'windsor'),
			'fixed'		=> esc_html__('Fixed', 'windsor'),
			'local'		=> esc_html__('Local', 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with 'Yes' and 'No' items
if ( !function_exists( 'windsor_get_list_yesno' ) ) {
	function windsor_get_list_yesno($prepend_inherit=false) {
		$list = array(
			"yes"	=> esc_html__("Yes", 'windsor'),
			"no"	=> esc_html__("No", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with 'On' and 'Of' items
if ( !function_exists( 'windsor_get_list_onoff' ) ) {
	function windsor_get_list_onoff($prepend_inherit=false) {
		$list = array(
			"on"	=> esc_html__("On", 'windsor'),
			"off"	=> esc_html__("Off", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with 'Show' and 'Hide' items
if ( !function_exists( 'windsor_get_list_showhide' ) ) {
	function windsor_get_list_showhide($prepend_inherit=false) {
		$list = array(
			"show" => esc_html__("Show", 'windsor'),
			"hide" => esc_html__("Hide", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with 'Horizontal' and 'Vertical' items
if ( !function_exists( 'windsor_get_list_directions' ) ) {
	function windsor_get_list_directions($prepend_inherit=false) {
		$list = array(
			"horizontal" => esc_html__("Horizontal", 'windsor'),
			"vertical"   => esc_html__("Vertical", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with 'Simple' and 'Advanced' items
if ( !function_exists( 'windsor_get_list_user_skills' ) ) {
	function windsor_get_list_user_skills($prepend_inherit=false) {
		$list = array(
			"simple"  => esc_html__("Simple", 'windsor'),
			"advanced" => esc_html__("Advanced", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with item's shapes
if ( !function_exists( 'windsor_get_list_shapes' ) ) {
	function windsor_get_list_shapes($prepend_inherit=false) {
		$list = array(
			"round"  => esc_html__("Round", 'windsor'),
			"square" => esc_html__("Square", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with item's sizes
if ( !function_exists( 'windsor_get_list_sizes' ) ) {
	function windsor_get_list_sizes($prepend_inherit=false) {
		$list = array(
			"tiny"   => esc_html__("Tiny", 'windsor'),
			"small"  => esc_html__("Small", 'windsor'),
			"medium" => esc_html__("Medium", 'windsor'),
			"large"  => esc_html__("Large", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with float items
if ( !function_exists( 'windsor_get_list_floats' ) ) {
	function windsor_get_list_floats($prepend_inherit=false) {
		$list = array(
			"none"  => esc_html__("None", 'windsor'),
			"left"  => esc_html__("Float Left", 'windsor'),
			"right" => esc_html__("Float Right", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with alignment items
if ( !function_exists( 'windsor_get_list_alignments' ) ) {
	function windsor_get_list_alignments($justify=false, $prepend_inherit=false) {
		$list = array(
			"none"	=> esc_html__("None", 'windsor'),
			"left"	=> esc_html__("Left", 'windsor'),
			"center"=> esc_html__("Center", 'windsor'),
			"right"	=> esc_html__("Right", 'windsor')
		);
		if ($justify) $list["justify"] = esc_html__("Justify", 'windsor');
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list with columns widths
if ( !function_exists( 'windsor_get_list_columns' ) ) {
	function windsor_get_list_columns($prepend_inherit=false) {
		$list = array(
			"none" => esc_html__("None", 'windsor'),
			"1_1" => esc_html__("100%", 'windsor'),
			"1_2" => esc_html__("1/2", 'windsor'),
			"1_3" => esc_html__("1/3", 'windsor'),
			"2_3" => esc_html__("2/3", 'windsor'),
			"1_4" => esc_html__("1/4", 'windsor'),
			"3_4" => esc_html__("3/4", 'windsor'),
			"1_5" => esc_html__("1/5", 'windsor'),
			"2_5" => esc_html__("2/5", 'windsor'),
			"3_5" => esc_html__("3/5", 'windsor'),
			"4_5" => esc_html__("4/5", 'windsor'),
			"1_6" => esc_html__("1/6", 'windsor'),
			"5_6" => esc_html__("5/6", 'windsor'),
			"1_7" => esc_html__("1/7", 'windsor'),
			"2_7" => esc_html__("2/7", 'windsor'),
			"3_7" => esc_html__("3/7", 'windsor'),
			"4_7" => esc_html__("4/7", 'windsor'),
			"5_7" => esc_html__("5/7", 'windsor'),
			"6_7" => esc_html__("6/7", 'windsor'),
			"1_8" => esc_html__("1/8", 'windsor'),
			"3_8" => esc_html__("3/8", 'windsor'),
			"5_8" => esc_html__("5/8", 'windsor'),
			"7_8" => esc_html__("7/8", 'windsor'),
			"1_9" => esc_html__("1/9", 'windsor'),
			"2_9" => esc_html__("2/9", 'windsor'),
			"4_9" => esc_html__("4/9", 'windsor'),
			"5_9" => esc_html__("5/9", 'windsor'),
			"7_9" => esc_html__("7/9", 'windsor'),
			"8_9" => esc_html__("8/9", 'windsor'),
			"1_10"=> esc_html__("1/10", 'windsor'),
			"3_10"=> esc_html__("3/10", 'windsor'),
			"7_10"=> esc_html__("7/10", 'windsor'),
			"9_10"=> esc_html__("9/10", 'windsor'),
			"1_11"=> esc_html__("1/11", 'windsor'),
			"2_11"=> esc_html__("2/11", 'windsor'),
			"3_11"=> esc_html__("3/11", 'windsor'),
			"4_11"=> esc_html__("4/11", 'windsor'),
			"5_11"=> esc_html__("5/11", 'windsor'),
			"6_11"=> esc_html__("6/11", 'windsor'),
			"7_11"=> esc_html__("7/11", 'windsor'),
			"8_11"=> esc_html__("8/11", 'windsor'),
			"9_11"=> esc_html__("9/11", 'windsor'),
			"10_11"=> esc_html__("10/11", 'windsor'),
			"1_12"=> esc_html__("1/12", 'windsor'),
			"5_12"=> esc_html__("5/12", 'windsor'),
			"7_12"=> esc_html__("7/12", 'windsor'),
			"10_12"=> esc_html__("10/12", 'windsor'),
			"11_12"=> esc_html__("11/12", 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return list of locations for the featured content
if ( !function_exists( 'windsor_get_list_featured_locations' ) ) {
	function windsor_get_list_featured_locations($prepend_inherit=false) {
		$list = array(
			"default" => esc_html__('As in the post defined', 'windsor'),
			"center"  => esc_html__('Above the text of the post', 'windsor'),
			"left"    => esc_html__('To the left the text of the post', 'windsor'),
			"right"   => esc_html__('To the right the text of the post', 'windsor'),
			"alter"   => esc_html__('Alternates for each post', 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return post-format name
if ( !function_exists( 'windsor_get_post_format_name' ) ) {
	function windsor_get_post_format_name($format, $single=true) {
		$name = '';
		if ($format=='gallery')		$name = $single ? esc_html__('gallery', 'windsor') : esc_html__('galleries', 'windsor');
		else if ($format=='video')	$name = $single ? esc_html__('video', 'windsor') : esc_html__('videos', 'windsor');
		else if ($format=='audio')	$name = $single ? esc_html__('audio', 'windsor') : esc_html__('audios', 'windsor');
		else if ($format=='image')	$name = $single ? esc_html__('image', 'windsor') : esc_html__('images', 'windsor');
		else if ($format=='quote')	$name = $single ? esc_html__('quote', 'windsor') : esc_html__('quotes', 'windsor');
		else if ($format=='link')	$name = $single ? esc_html__('link', 'windsor') : esc_html__('links', 'windsor');
		else if ($format=='status')	$name = $single ? esc_html__('status', 'windsor') : esc_html__('statuses', 'windsor');
		else if ($format=='aside')	$name = $single ? esc_html__('aside', 'windsor') : esc_html__('asides', 'windsor');
		else if ($format=='chat')	$name = $single ? esc_html__('chat', 'windsor') : esc_html__('chats', 'windsor');
		else						$name = $single ? esc_html__('standard', 'windsor') : esc_html__('standards', 'windsor');
		return $name;
	}
}

// Return post-format icon name (from Fontello library)
if ( !function_exists( 'windsor_get_post_format_icon' ) ) {
	function windsor_get_post_format_icon($format) {
		$icon = 'icon-';
		if ($format=='gallery')		$icon .= 'pictures';
		else if ($format=='video')	$icon .= 'video';
		else if ($format=='audio')	$icon .= 'note';
		else if ($format=='image')	$icon .= 'picture';
		else if ($format=='quote')	$icon .= 'quote';
		else if ($format=='link')	$icon .= 'link';
		else if ($format=='status')	$icon .= 'comment';
		else if ($format=='aside')	$icon .= 'doc-text';
		else if ($format=='chat')	$icon .= 'chat';
		else						$icon .= 'book-open';
		return $icon;
	}
}

// Return fonts styles list, prepended inherit
if ( !function_exists( 'windsor_get_list_fonts_styles' ) ) {
	function windsor_get_list_fonts_styles($prepend_inherit=false) {
		$list = array(
			'i' => esc_html__('I','windsor'),
			'u' => esc_html__('U', 'windsor')
		);
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return Google fonts list
if ( !function_exists( 'windsor_get_list_fonts' ) ) {
	function windsor_get_list_fonts($prepend_inherit=false) {
		if (($list = windsor_storage_get('list_fonts'))=='') {
			$list = array(
				'Advent Pro' => array('family'=>'sans-serif'),
				'Alegreya Sans' => array('family'=>'sans-serif'),
				'Arimo' => array('family'=>'sans-serif'),
				'Asap' => array('family'=>'sans-serif'),
				'Averia Sans Libre' => array('family'=>'cursive'),
				'Averia Serif Libre' => array('family'=>'cursive'),
				'Bree Serif' => array('family'=>'serif',),
				'Cabin' => array('family'=>'sans-serif'),
				'Cabin Condensed' => array('family'=>'sans-serif'),
				'Cardo' => array('family'=>'serif'),
				'Caudex' => array('family'=>'serif'),
				'Comfortaa' => array('family'=>'cursive'),
				'Cousine' => array('family'=>'sans-serif'),
				'Crimson Text' => array('family'=>'serif'),
				'Cuprum' => array('family'=>'sans-serif'),
				'Dosis' => array('family'=>'sans-serif'),
				'Economica' => array('family'=>'sans-serif'),
				'Exo' => array('family'=>'sans-serif'),
				'Expletus Sans' => array('family'=>'cursive'),
				'Karla' => array('family'=>'sans-serif'),
				'Lato' => array('family'=>'sans-serif'),
				'Lekton' => array('family'=>'sans-serif'),
				'Lobster Two' => array('family'=>'cursive'),
				'Maven Pro' => array('family'=>'sans-serif'),
				'Merriweather' => array('family'=>'serif'),
				'Montserrat' => array('family'=>'sans-serif'),
				'Neuton' => array('family'=>'serif'),
				'Noticia Text' => array('family'=>'serif'),
				'Old Standard TT' => array('family'=>'serif'),
				'Open Sans' => array('family'=>'sans-serif'),
				'Orbitron' => array('family'=>'sans-serif'),
				'Oswald' => array('family'=>'sans-serif'),
				'Overlock' => array('family'=>'cursive'),
				'Oxygen' => array('family'=>'sans-serif'),
				'PT Serif' => array('family'=>'serif'),
				'Puritan' => array('family'=>'sans-serif'),
				'Raleway' => array('family'=>'sans-serif'),
				'Roboto' => array('family'=>'sans-serif'),
				'Roboto Slab' => array('family'=>'sans-serif'),
				'Roboto Condensed' => array('family'=>'sans-serif'),
				'Rosario' => array('family'=>'sans-serif'),
				'Share' => array('family'=>'cursive'),
				'Signika' => array('family'=>'sans-serif'),
				'Signika Negative' => array('family'=>'sans-serif'),
				'Source Sans Pro' => array('family'=>'sans-serif'),
				'Tinos' => array('family'=>'serif'),
				'Ubuntu' => array('family'=>'sans-serif'),
				'Vollkorn' => array('family'=>'serif')
			);
			$list = windsor_array_merge($list, windsor_get_list_font_faces());
			windsor_storage_get('list_fonts', $list);
		}
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}

// Return Custom font-face list
if ( !function_exists( 'windsor_get_list_font_faces' ) ) {
	function windsor_get_list_font_faces($prepend_inherit=false) {
		static $list = false;
		if (is_array($list)) return $list;
		$fonts = windsor_storage_get('required_custom_fonts');
		$list = array();
		if (is_array($fonts)) {
			foreach ($fonts as $font) {
				if (($url = windsor_get_file_url( sprintf('css/font-face/%s/stylesheet.css', $font))) != '') {
					$list[sprintf(esc_html__('%s (uploaded font)', 'windsor'), $font)] = array('css' => $url);
				}
			}
		}
		return $list;
	}
}

// Return iconed classes list
if ( !function_exists( 'windsor_get_list_icons' ) ) {
	function windsor_get_list_icons($prepend_inherit=false) {
		static $list = false;
		if (is_array($list)) return $list;
		$list = windsor_parse_icons_classes(windsor_get_file_dir("css/fontello/css/fontello-codes.css"));
		return $prepend_inherit ? windsor_array_merge(array('inherit' => esc_html__("Inherit", 'windsor')), $list) : $list;
	}
}
?>