<?php
/**
 * Theme functions: init, enqueue scripts and styles, include required files and widgets
 *
 * @package WordPress
 * @subpackage WINDSOR
 * @since WINDSOR 1.0
 */

/**
 * Fire the wp_body_open action.
 *
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
 */
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        /**
         * Triggered after the opening <body> tag.
         */
        do_action('wp_body_open');
    }
}

// Theme storage
$WINDSOR_STORAGE = array(

	// Theme required plugin's slugs
	'required_plugins' => array(

		// Required plugins
		// DON'T COMMENT OR REMOVE NEXT LINES!
		'trx_addons',

		// Recommended (supported) plugins
		// If plugin not need - comment (or remove) it
		'revslider',
		'js_composer',
		'vc-extensions-bundle',
		'woocommerce',
        'elegro-payment',
		'mailchimp-for-wp',
		'the-events-calendar',
		'bbpress',
		'essential-grid',
		'contact-form-7',
        'trx_updater',
		),

	// Set list of the theme required custom fonts from folder /css/font-faces
	// Attention! Font's folder must have name equal to the font's name
	'required_custom_fonts' => array(
		'antonio',
		'texgyretermes'
		)

);


//-------------------------------------------------------
//-- Theme init
//-------------------------------------------------------

if ( !function_exists('windsor_theme_setup1') ) {
	
	add_action( 'after_setup_theme', 'windsor_theme_setup1', 1 );

	function windsor_theme_setup1() {
		// Set theme content width
		$GLOBALS['content_width'] = apply_filters( 'windsor_filter_content_width', 1170 );
	}
}

if ( !function_exists('windsor_theme_setup') ) {
	
	add_action( 'after_setup_theme', 'windsor_theme_setup' );

	function windsor_theme_setup() {

		// Add default posts and comments RSS feed links to head 
		add_theme_support( 'automatic-feed-links' );
		
		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );

		// Add wide and full blocks support
		add_theme_support( 'align-wide' );
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('windsor_filter_add_thumb_sizes', array(
			'windsor-thumb-huge'		=> array(1170, 658, true),
			'windsor-thumb-big' 		=> array( 740, 416, true),
			'windsor-thumb-med' 		=> array( 370, 208, true),
			'windsor-thumb-tiny' 		=> array(  90,  90, true),
			'windsor-thumb-masonry-big' => array( 770,   0, false),		// Only downscale, not crop
			'windsor-thumb-masonry'		=> array( 370,   0, false),		// Only downscale, not crop
			)
		);
		$mult = windsor_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'windsor_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}
		
		// Custom header setup
		add_theme_support( 'custom-header', array(
			'header-text'=>false
			)
		);

		// Custom backgrounds setup
		add_theme_support( 'custom-background', array()	);
		
		// Supported posts formats
		add_theme_support( 'post-formats', array('gallery', 'video', 'audio', 'link', 'quote', 'image', 'status', 'aside', 'chat') ); 
 
 		// Autogenerate title tag
		add_theme_support('title-tag');
 		
		// Add theme menus
		add_theme_support('nav-menus');
		
		// Switch default markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption') );
		
		// Editor custom stylesheet - for user
		add_editor_style( array_merge(
			array(
				'css/editor-style.css',
				windsor_get_file_url('css/fontello/css/fontello-embedded.css')
			),
			windsor_theme_fonts_for_editor()
			)
		);	
		
		// Make theme available for translation
		// Translations can be filed in the /languages/ directory
		load_theme_textdomain( 'windsor', windsor_get_folder_dir('languages') );
	
		// Register navigation menu
		register_nav_menus(array(
			'menu_main' => esc_html__('Main Menu', 'windsor'),
			'menu_header' => esc_html__('Header Menu', 'windsor'),
			'menu_footer' => esc_html__('Footer Menu', 'windsor')
			)
		);

		// Excerpt filters
		add_filter( 'excerpt_length',						'windsor_excerpt_length' );
		add_filter( 'excerpt_more',							'windsor_excerpt_more' );
		
		// Add required meta tags in the head
		add_action('wp_head',		 						'windsor_wp_head', 1);
		
		// Add custom inline styles
		add_action('wp_footer',		 						'windsor_wp_footer');
		add_action('admin_footer',	 						'windsor_wp_footer');

		// Enqueue scripts and styles for frontend
		add_action('wp_enqueue_scripts', 					'windsor_wp_scripts', 1000);			//priority 1000 - load styles before the plugin's support custom styles (priority 1100)
		add_action('wp_enqueue_scripts',					'windsor_wp_scripts_child', 1200);
		add_action('wp_enqueue_scripts', 					'windsor_wp_scripts_responsive', 2000);	//priority 2000 - load responsive after all other styles
		
		// Add body classes
		add_filter( 'body_class',							'windsor_add_body_classes' );

		// Enqueue scripts and styles for admin
		add_action("admin_enqueue_scripts",					'windsor_admin_scripts');

		// Register sidebars
		add_action('widgets_init', 							'windsor_widgets_init');

		// TGM Activation plugin
		add_action('tgmpa_register',						'windsor_register_plugins');

		// Set options for importer (before other plugins)
		add_filter( 'trx_addons_filter_importer_options',    'windsor_importer_set_options', 9 );

		/**
		 * Allows visitors to page forward/backwards in any direction within month view
		 * an "infinite" number of times (ie, outwith the populated range of months).
		 */
		add_filter( 'tribe_events_the_next_month_link', 	'windsor_tribe_events_next_month' );
		add_filter( 'tribe_events_the_previous_month_link', 'windsor_tribe_events_previous_month' );

	}

}


if ( !function_exists( 'windsor_tribe_events_next_month' ) ) {

	function windsor_tribe_events_next_month() {
		$url = tribe_get_next_month_link();
		$text = tribe_get_next_month_text();
		$date = Tribe__Events__Main::instance()->nextMonth( tribe_get_month_view_date() );
		return '<a data-month="' . $date . '" href="' . esc_url($url) . '" rel="next">' . $text . ' <span>&raquo;</span></a>';
	}
}

if ( !function_exists( 'windsor_tribe_events_previous_month' ) ) {

	function windsor_tribe_events_previous_month() {
		$url = tribe_get_previous_month_link();
		$text = tribe_get_previous_month_text();
		$date = Tribe__Events__Main::instance()->previousMonth( tribe_get_month_view_date() );
		return '<a data-month="' . $date . '" href="' . esc_url($url) . '" rel="prev"><span>&laquo;</span> ' . $text . ' </a>';
	}
}



//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------
if ( !function_exists('windsor_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'windsor_image_sizes' );
	function windsor_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('windsor_filter_add_thumb_sizes', array(
			'windsor-thumb-huge'		=> esc_html__( 'Fullsize image', 'windsor' ),
			'windsor-thumb-big'			=> esc_html__( 'Large image', 'windsor' ),
			'windsor-thumb-med'			=> esc_html__( 'Medium image', 'windsor' ),
			'windsor-thumb-tiny'		=> esc_html__( 'Small square avatar', 'windsor' ),
			'windsor-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'windsor' ),
			'windsor-thumb-masonry'		=> esc_html__( 'Masonry (scaled)', 'windsor' ),
			)
		);
		$mult = windsor_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'windsor' );
		}
		return $sizes;
	}
}


//-------------------------------------------------------
//-- Theme scripts and styles
//-------------------------------------------------------

// Load frontend scripts
if ( !function_exists( 'windsor_wp_scripts' ) ) {
	
	function windsor_wp_scripts() {
		
		// Enqueue styles
		//------------------------
		
		// Links to selected fonts
		$links = windsor_theme_fonts_links();
		if (count($links) > 0) {
			foreach ($links as $slug => $link) {
                wp_enqueue_style( sprintf('windsor-font-%s', $slug), $link );
			}
		}
		
		// Fontello styles must be loaded before main stylesheet
		// This style NEED the theme prefix, because style 'fontello' in some plugin contain different set of characters
		// and can't be used instead this style!
        wp_enqueue_style( 'fontello-icons',  windsor_get_file_url('css/fontello/css/fontello-embedded.css') );

		// Load main stylesheet
        wp_enqueue_style( 'windsor-main', get_template_directory_uri() . '/style.css', array(), null );

		// Animations
		if ( (windsor_get_theme_option('blog_animation')!='none' || windsor_get_theme_option('menu_animation_in')!='none' || windsor_get_theme_option('menu_animation_out')!='none') && (windsor_get_theme_option('animation_on_mobile')=='yes' || !wp_is_mobile()) && (!function_exists('windsor_vc_is_frontend') || !windsor_vc_is_frontend()))
            wp_enqueue_style( 'windsor-animation',	windsor_get_file_url('css/animation.css') );

		// Custom colors
		if ( !is_customize_preview() && !isset($_GET['color_scheme']) && windsor_is_off(windsor_get_theme_option('debug_mode')) )
            wp_enqueue_style( 'windsor-colors', windsor_get_file_url('css/__colors.css') );
		else
			wp_add_inline_style( 'windsor-main', windsor_customizer_get_css() );

		// Merged styles
		if ( windsor_is_off(windsor_get_theme_option('debug_mode')) )
            wp_enqueue_style( 'windsor-styles', windsor_get_file_url('css/__styles.css') );

		// Add post nav background
		windsor_add_bg_in_post_nav();

		// Disable loading JQuery UI CSS
		wp_deregister_style('jquery_ui');
		wp_deregister_style('date-picker-css');


		// Enqueue scripts	
		//------------------------
		
		// Modernizr will load in head before other scripts and styles
		if ( substr(windsor_get_theme_option('blog_style'), 0, 7) == 'gallery' || substr(windsor_get_theme_option('blog_style'), 0, 9) == 'portfolio' )
			wp_enqueue_script( 'modernizr', windsor_get_file_url('js/theme.gallery/modernizr.min.js'), array(), null, true);
		
		// Merged scripts
		if ( windsor_is_off(windsor_get_theme_option('debug_mode')) )
            wp_enqueue_script( 'windsor-init', windsor_get_file_url('js/__scripts.js'), array('jquery'), null, true );
		else {
			// Skip link focus
            wp_enqueue_script( 'skip-link-focus-fix', windsor_get_file_url('js/skip-link-focus-fix.js'), array('jquery'), null, true );
			// Superfish Menu
            wp_enqueue_script( 'superfish', windsor_get_file_url('js/superfish.js'), array('jquery'), null, true );

			// Background video
			$header_video = windsor_get_theme_option('header_video');
			if (!empty($header_video) && !windsor_is_inherit($header_video))
                wp_enqueue_script( 'bideo', windsor_get_file_url('js/bideo.js'), array(), null, true );
			// Theme scripts
            wp_enqueue_script( 'windsor-utils', windsor_get_file_url('js/_utils.js'), array('jquery'), null, true );
            wp_enqueue_script( 'windsor-init', windsor_get_file_url('js/_init.js'), array('jquery'), null, true );
		}

		// Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Media elements library	
		if (windsor_get_theme_setting('use_mediaelements')) {
			wp_enqueue_style ( 'mediaelement' );
			wp_enqueue_style ( 'wp-mediaelement' );
			wp_enqueue_script( 'mediaelement' );
			wp_enqueue_script( 'wp-mediaelement' );
		}

		wp_localize_script( 'windsor-init', 'WINDSOR_STORAGE', apply_filters( 'windsor_filter_localize_script', array(
			// AJAX parameters
			'ajax_url' => esc_url(admin_url('admin-ajax.php')),
			'ajax_nonce' => esc_attr(wp_create_nonce(admin_url('admin-ajax.php'))),
			
			// Site base url
			'site_url' => get_site_url(),
			
			// User logged in
			'user_logged_in' => is_user_logged_in() ? true : false,
			
			// Menu width for mobile mode
			'mobile_layout_width' => max(480, windsor_get_theme_option('mobile_layout_width')),

			// Use menu cache
			'menu_cache' => windsor_is_on(windsor_get_theme_option('menu_cache')),

			// Stretch sidemenu to window height
			'menu_stretch' => windsor_is_on(windsor_get_theme_option('menu_stretch')),

			// Menu animation
			'menu_animation_in' => windsor_get_theme_option('menu_animation_in'),
            'menu_animation_out' => windsor_get_theme_option('menu_animation_out'),

			// Video background
			'background_video' => windsor_get_theme_option('header_video'),

			// Video and Audio tag wrapper
			'use_mediaelements' => windsor_get_theme_setting('use_mediaelements') ? true : false,

			// Messages max length
			'message_maxlength'	=> intval(windsor_get_theme_setting('message_maxlength')),
						
			// Site color scheme
			'site_scheme' => sprintf('scheme_%s', windsor_get_theme_option('color_scheme')),

			
			// Internal vars - do not change it!
			
			// Flag for review mechanism
			'admin_mode' => false,

			// E-mail mask
			'email_mask' => '^([a-zA-Z0-9_\\-]+\\.)*[a-zA-Z0-9_\\-]+@[a-z0-9_\\-]+(\\.[a-z0-9_\\-]+)*\\.[a-z]{2,6}$',
			
			// Strings for translation
			'strings' => array(
					'ajax_error'		=> esc_html__('Invalid server answer!', 'windsor'),
					'error_global'		=> esc_html__('Error data validation!', 'windsor'),
					'name_empty' 		=> esc_html__("The name can't be empty", 'windsor'),
					'name_long'			=> esc_html__('Too long name', 'windsor'),
					'email_empty'		=> esc_html__('Too short (or empty) email address', 'windsor'),
					'email_long'		=> esc_html__('Too long email address', 'windsor'),
					'email_not_valid'	=> esc_html__('Invalid email address', 'windsor'),
					'text_empty'		=> esc_html__("The message text can't be empty", 'windsor'),
					'text_long'			=> esc_html__('Too long message text', 'windsor'),
					'search_error'		=> esc_html__('Search error! Try again later.', 'windsor'),
					'send_complete'		=> esc_html__("Send message complete!", 'windsor'),
					'send_error'		=> esc_html__('Transmit failed!', 'windsor')
					)
			))
		);
	}
}

// Load frontend scripts for the child-theme (if active)
if ( !function_exists( 'windsor_wp_scripts_child' ) ) {
	
	function windsor_wp_scripts_child() {
		$main_stylesheet = get_template_directory_uri() . '/style.css';
		$child_stylesheet = get_stylesheet_directory_uri() . '/style.css';
		if ($child_stylesheet != $main_stylesheet) {
            wp_enqueue_style( 'windsor-child', $child_stylesheet, array('windsor-main'), null );
		}
	}
}
// Load responsive styles (priority 2000 - load it after main styles and plugins custom styles)
if ( !function_exists( 'windsor_wp_scripts_responsive' ) ) {
	
	function windsor_wp_scripts_responsive() {
        wp_enqueue_style( 'windsor-responsive', windsor_get_file_url('css/responsive.css') );
	}
}

//  Add meta tags and inline scripts in the header for frontend
if (!function_exists('windsor_wp_head')) {
	
	function windsor_wp_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link rel="profile" href="//gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php
	}
}

// Add theme specified classes into the body
if ( !function_exists('windsor_add_body_classes') ) {
	
	function windsor_add_body_classes( $classes ) {
		$blog_mode = windsor_storage_get('blog_mode');
		$classes[] = 'blog_mode_' . esc_html($blog_mode);
		$classes[] = 'body_tag';	// Need for the .scheme_self
		$classes[] = 'body_style_' . esc_html(windsor_get_theme_option('body_style'));
		$classes[] = 'scheme_' . esc_html(windsor_get_theme_option('color_scheme'));
		if (in_array($blog_mode, array('post', 'page'))) {
			$classes[] = 'is_single';
		} else {
			$classes[] = ' is_stream';
			$classes[] = 'blog_style_'.esc_html(windsor_get_theme_option('blog_style'));
		}
		if (windsor_sidebar_present()) {
			$classes[] = 'sidebar_show sidebar_' . esc_html(windsor_get_theme_option('sidebar_position')) ;
		} else {
			$classes[] = 'sidebar_hide';
			if (windsor_is_on(windsor_get_theme_option('expand_content')))
				 $classes[] = 'expand_content';
		}
		if (windsor_is_on(windsor_get_theme_option('remove_margins')))
			 $classes[] = 'remove_margins';
		
		$classes[] = 'header_style_' . esc_html(windsor_get_theme_option("header_style"));
		$classes[] = 'header_position_' . esc_html(windsor_get_theme_option("header_position"));
		$classes[] = 'header_title_' . esc_html(windsor_need_page_title() ? 'on' : 'off');

		$menu_style= windsor_get_theme_option("menu_style");
		$classes[] = 'menu_style_' . esc_html($menu_style) . (in_array($menu_style, array('left', 'right'))	? ' menu_style_side' : '');
		$classes[] = 'no_layout';
		
		return $classes;
	}
}
	
// Load inline styles
if ( !function_exists( 'windsor_wp_footer' ) ) {
	
	function windsor_wp_footer() {
		// Get inline styles from storage
		if (($css = windsor_storage_get('inline_styles')) != '') {
            wp_enqueue_style(  'windsor-inline-styles',  windsor_get_file_url('css/__inline.css') );
			wp_add_inline_style( 'windsor-inline-styles', $css );
		}
	}
}
	
// Load required styles and scripts for admin mode
if ( !function_exists( 'windsor_admin_scripts' ) ) {
	
	function windsor_admin_scripts() {

		// Add theme styles
        wp_enqueue_style(  'windsor-admin',  windsor_get_file_url('css/admin.css') );

		// Links to selected fonts
		$screen = get_current_screen();
		if (windsor_allow_override($screen->id) && windsor_allow_override($screen->post_type)) {
			// Load fontello icons
			// This style NEED theme prefix, because style 'fontello' some plugin contain different set of characters
			// and can't be used instead this style!
            wp_enqueue_style(  'fontello-icons', windsor_get_file_url('css/fontello/css/fontello-embedded.css') );
			// Load theme fonts
			$links = windsor_theme_fonts_links(false);
			if (count($links) > 0) {
				foreach ($links as $slug => $link) {
                    wp_enqueue_style( sprintf('windsor-font-%s', $slug), $link );
				}
			}
		}

		// Add theme scripts
        wp_enqueue_script( 'windsor-utils', windsor_get_file_url('js/_utils.js'), array('jquery'), null, true );
        wp_enqueue_script( 'windsor-admin', windsor_get_file_url('js/_admin.js'), array('jquery') , null, true);

		wp_localize_script( 'windsor-admin', 'WINDSOR_STORAGE', apply_filters( 'windsor_filter_localize_script_admin', array(
			'admin_mode' => true,
			'ajax_url' => esc_url(admin_url('admin-ajax.php')),
			'ajax_nonce' => esc_attr(wp_create_nonce(admin_url('admin-ajax.php'))),
			'importer_error_msg' => esc_html__('Errors that occurred during the import process:', 'windsor'),
			'user_logged_in' => true
			))
		);
	}
}


//-------------------------------------------------------
//-- Sidebars and widgets
//-------------------------------------------------------

// Register widgetized areas
if ( !function_exists('windsor_widgets_init') ) {
	function windsor_widgets_init() {
		$sidebars = windsor_get_list_sidebars();
		if (is_array($sidebars) && count($sidebars) > 0) {
			foreach ($sidebars as $id=>$name) {
				register_sidebar( array(
										'name'          => $name,
										'id'            => $id,
										'before_widget' => '<aside id="%1$s" class="widget %2$s">',
										'after_widget'  => '</aside>',
										'before_title'  => '<h5 class="widget_title">',
										'after_title'   => '</h5>'
										)
								);
			}
		}
	}
}


//-------------------------------------------------------
//-- Theme fonts
//-------------------------------------------------------

// Return links for all theme fonts
if ( !function_exists('windsor_theme_fonts_links') ) {
	function windsor_theme_fonts_links($all_tags=true) {
		$links = array();
		
		/*
		Translators: If there are characters in your language that are not supported
		by chosen font(s), translate this to 'off'. Do not translate into your own language.
		*/
		$google_fonts_enabled = ( 'off' !== esc_html_x ( 'on', 'Google fonts: on or off', 'windsor' ) );
		$custom_fonts_enabled = ( 'off' !== esc_html_x ( 'on', 'Custom fonts (included in the theme): on or off', 'windsor' ) );
		
		if ( ($google_fonts_enabled || $custom_fonts_enabled) && !windsor_storage_empty('theme_fonts') ) {
			$theme_fonts = windsor_storage_get('theme_fonts');
			if (count($theme_fonts) > 0) {
				$google_fonts = '';
				foreach ($theme_fonts as $tag => $font) {
					if (!$all_tags && in_array($tag, array('logo', 'info', 'menu', 'submenu', 'decor'))) continue;	// Skip non content tags (for admin mode)
					if (empty($font['family']) || windsor_is_inherit($font['family']) || (empty($font['link']) && empty($font['css']))) continue;
					$font_name = str_replace('"', '', ($pos=strpos($font['family'], ','))!==false ? substr($font['family'], 0, $pos) : $font['family']);
					if (!empty($font['css'])) {
						if ($custom_fonts_enabled) {
							$links[str_replace(' ', '-', $font_name)] = $font['css'];
						}
					} else {
						if ($google_fonts_enabled) {
							$google_fonts .= ($google_fonts ? '|' : '') 
											. (!empty($font['link']) ? $font['link'] : str_replace(' ', '+', $font_name).':400,400italic,700,700italic');
						}
					}
				}
				if ($google_fonts && $google_fonts_enabled)
					$links['google_fonts'] = sprintf('%s://fonts.googleapis.com/css?family=%s&subset=latin,latin-ext', windsor_get_protocol(), $google_fonts);
			}
		}
		return $links;
	}
}

// Return links for WP Editor
if ( !function_exists('windsor_theme_fonts_for_editor') ) {
	function windsor_theme_fonts_for_editor() {
		$links = array_values(windsor_theme_fonts_links(false));
		if (is_array($links) && count($links) > 0) {
			for ($i=0; $i<count($links); $i++) {
				$links[$i] = str_replace(',', '%2C', $links[$i]);
			}
		}
		return $links;
	}
}


//-------------------------------------------------------
//-- The Excerpt
//-------------------------------------------------------
if ( !function_exists('windsor_excerpt_length') ) {
	function windsor_excerpt_length( $length ) {
		return max(1, windsor_get_theme_setting('max_excerpt_length'));
	}
}

if ( !function_exists('windsor_excerpt_more') ) {
	function windsor_excerpt_more( $more ) {
		return '&hellip;';
	}
}



//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'windsor_importer_set_options' ) ) {
    add_filter( 'trx_addons_filter_importer_options', 'windsor_importer_set_options', 9 );
    function windsor_importer_set_options( $options=array() ) {
        if ( is_array( $options ) ) {
            // Save or not installer's messages to the log-file
            $options['debug'] = false;
            // Prepare demo data

            $options['demo_url'] = esc_url( windsor_get_protocol().'://demofiles.themerex.net/windsor/' ); // Demo-site domain


            // Required plugins
            $options['required_plugins'] =  array(
                'revslider',
                'js_composer',
                'vc-extensions-bundle',
                'woocommerce',
                'elegro-payment',
                'mailchimp-for-wp',
                'the-events-calendar',
                'bbpress',
                'essential-grid',
                'contact-form-7',
                'gdpr-framework',
                'trx_updater',
            );

            $options['theme_slug'] = 'windsor';

            // Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
            // Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
            $options['regenerate_thumbnails'] = 0;
            // Default demo
            $options['files']['default']['title'] = esc_html__( 'Education Demo', 'windsor' );
            $options['files']['default']['domain_dev'] = esc_url(windsor_get_protocol().'://windsor.upd.themerex.net');		// Developers domain
            $options['files']['default']['domain_demo']= esc_url('http://windsor.themerex.net');		// Demo-site domain

        }
        return $options;
    }
}



//-------------------------------------------------------
//-- Third party plugins
//-------------------------------------------------------

// Register optional plugins
if ( !function_exists( 'windsor_register_plugins' ) ) {
	function windsor_register_plugins() {
		tgmpa(	apply_filters('windsor_filter_tgmpa_required_plugins', array(
				// Plugins to include in the autoinstall queue.
				)),
				array(
					'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
					'default_path' => '',                      // Default absolute path to bundled plugins.
					'menu'         => 'tgmpa-install-plugins', // Menu slug.
					'parent_slug'  => 'themes.php',            // Parent menu slug.
					'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
					'has_notices'  => true,                    // Show admin notices or not.
					'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
					'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
					'is_automatic' => true,                    // Automatically activate plugins after installation or not.
					'message'      => ''                       // Message to output right before the plugins table.
				)
			);
	}
}


// Add class trx_utils_activated
if(!function_exists('windsor_add_body_class')) {
    if(!function_exists ( 'trx_addons_activate')){
        add_filter( 'body_class', 'windsor_add_body_class' );
        function windsor_add_body_class($classes){
            $classes[] = 'default_theme';
            return $classes;
        }
    }
}



//-------------------------------------------------------
//-- Include theme (or child) PHP-files
//-------------------------------------------------------

require_once trailingslashit( get_template_directory() ) . 'includes/utils.php';
require_once trailingslashit( get_template_directory() ) . 'includes/storage.php';
require_once trailingslashit( get_template_directory() ) . 'includes/lists.php';
require_once trailingslashit( get_template_directory() ) . 'includes/wp.php';

require_once trailingslashit( get_template_directory() ) . 'includes/theme.tags.php';
require_once trailingslashit( get_template_directory() ) . 'includes/theme.hovers/theme.hovers.php';

if (is_admin()) {
	require_once trailingslashit( get_template_directory() ) . 'includes/tgmpa/class-tgm-plugin-activation.php';
}

require_once trailingslashit( get_template_directory() ) . 'theme-options/theme.customizer.php';

// Plugins support
if (is_array($WINDSOR_STORAGE['required_plugins']) && count($WINDSOR_STORAGE['required_plugins']) > 0) {
	foreach ($WINDSOR_STORAGE['required_plugins'] as $plugin_slug) {
		$plugin_path = trailingslashit( get_template_directory() ) . sprintf('plugins/plugin.%s.php', windsor_esc($plugin_slug));
		if (file_exists($plugin_path)) { require_once $plugin_path; }
	}
}
?>